<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class SessionOptions {
    /**
     * @param string $friendlyName The human-readable name of this session.
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @param \DateTime $dateCreated The date that this resource was created.
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @param string $createdBy Identity of the session's creator.
     * @param string $twilioAddress Twilio address the participant is contacting to.
     * @param string $userAddress Address the participant is contacting from.
     * @return CreateSessionOptions Options builder
     */
    public static function create($friendlyName = Values::NONE, $attributes = Values::NONE, $dateCreated = Values::NONE, $dateUpdated = Values::NONE, $createdBy = Values::NONE, $twilioAddress = Values::NONE, $userAddress = Values::NONE) {
        return new CreateSessionOptions($friendlyName, $attributes, $dateCreated, $dateUpdated, $createdBy, $twilioAddress, $userAddress);
    }

    /**
     * @param string $friendlyName The human-readable name of this session.
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @param \DateTime $dateCreated The date that this resource was created.
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @param string $createdBy Identity of the session's creator.
     * @return UpdateSessionOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $attributes = Values::NONE, $dateCreated = Values::NONE, $dateUpdated = Values::NONE, $createdBy = Values::NONE) {
        return new UpdateSessionOptions($friendlyName, $attributes, $dateCreated, $dateUpdated, $createdBy);
    }
}

class CreateSessionOptions extends Options {
    /**
     * @param string $friendlyName The human-readable name of this session.
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @param \DateTime $dateCreated The date that this resource was created.
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @param string $createdBy Identity of the session's creator.
     * @param string $twilioAddress Twilio address the participant is contacting to.
     * @param string $userAddress Address the participant is contacting from.
     */
    public function __construct($friendlyName = Values::NONE, $attributes = Values::NONE, $dateCreated = Values::NONE, $dateUpdated = Values::NONE, $createdBy = Values::NONE, $twilioAddress = Values::NONE, $userAddress = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['attributes'] = $attributes;
        $this->options['dateCreated'] = $dateCreated;
        $this->options['dateUpdated'] = $dateUpdated;
        $this->options['createdBy'] = $createdBy;
        $this->options['twilioAddress'] = $twilioAddress;
        $this->options['userAddress'] = $userAddress;
    }

    /**
     * The human-readable name of this session. Optional.
     * 
     * @param string $friendlyName The human-readable name of this session.
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * An optional string metadata field you can use to store any data you wish. The string value must contain structurally valid JSON if specified.  **Note** that if the attributes are not set "{}" will be returned.
     * 
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @return $this Fluent Builder
     */
    public function setAttributes($attributes) {
        $this->options['attributes'] = $attributes;
        return $this;
    }

    /**
     * The date that this resource was created.
     * 
     * @param \DateTime $dateCreated The date that this resource was created.
     * @return $this Fluent Builder
     */
    public function setDateCreated($dateCreated) {
        $this->options['dateCreated'] = $dateCreated;
        return $this;
    }

    /**
     * The date that this resource was last updated.
     * 
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @return $this Fluent Builder
     */
    public function setDateUpdated($dateUpdated) {
        $this->options['dateUpdated'] = $dateUpdated;
        return $this;
    }

    /**
     * Identity of the session's creator. If the Session was created through the API, the value will be `system`
     * 
     * @param string $createdBy Identity of the session's creator.
     * @return $this Fluent Builder
     */
    public function setCreatedBy($createdBy) {
        $this->options['createdBy'] = $createdBy;
        return $this;
    }

    /**
     * Twilio address the participant is contacting to. Together with User address defines the participant.
     * 
     * @param string $twilioAddress Twilio address the participant is contacting to.
     * @return $this Fluent Builder
     */
    public function setTwilioAddress($twilioAddress) {
        $this->options['twilioAddress'] = $twilioAddress;
        return $this;
    }

    /**
     * Address the participant is contacting from. Together with Twilio address defines the participant.
     * 
     * @param string $userAddress Address the participant is contacting from.
     * @return $this Fluent Builder
     */
    public function setUserAddress($userAddress) {
        $this->options['userAddress'] = $userAddress;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Messaging.V1.CreateSessionOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateSessionOptions extends Options {
    /**
     * @param string $friendlyName The human-readable name of this session.
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @param \DateTime $dateCreated The date that this resource was created.
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @param string $createdBy Identity of the session's creator.
     */
    public function __construct($friendlyName = Values::NONE, $attributes = Values::NONE, $dateCreated = Values::NONE, $dateUpdated = Values::NONE, $createdBy = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['attributes'] = $attributes;
        $this->options['dateCreated'] = $dateCreated;
        $this->options['dateUpdated'] = $dateUpdated;
        $this->options['createdBy'] = $createdBy;
    }

    /**
     * The human-readable name of this session. Optional.
     * 
     * @param string $friendlyName The human-readable name of this session.
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * An optional string metadata field you can use to store any data you wish. The string value must contain structurally valid JSON if specified.  **Note** that if the attributes are not set "{}" will be returned.
     * 
     * @param string $attributes An optional string metadata field you can use to
     *                           store any data you wish.
     * @return $this Fluent Builder
     */
    public function setAttributes($attributes) {
        $this->options['attributes'] = $attributes;
        return $this;
    }

    /**
     * The date that this resource was created.
     * 
     * @param \DateTime $dateCreated The date that this resource was created.
     * @return $this Fluent Builder
     */
    public function setDateCreated($dateCreated) {
        $this->options['dateCreated'] = $dateCreated;
        return $this;
    }

    /**
     * The date that this resource was last updated.
     * 
     * @param \DateTime $dateUpdated The date that this resource was last updated.
     * @return $this Fluent Builder
     */
    public function setDateUpdated($dateUpdated) {
        $this->options['dateUpdated'] = $dateUpdated;
        return $this;
    }

    /**
     * Identity of the session's creator. If the Session was created through the API, the value will be `system`
     * 
     * @param string $createdBy Identity of the session's creator.
     * @return $this Fluent Builder
     */
    public function setCreatedBy($createdBy) {
        $this->options['createdBy'] = $createdBy;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Messaging.V1.UpdateSessionOptions ' . implode(' ', $options) . ']';
    }
}