<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class WebhookOptions {
    /**
     * @param string $webhookMethod The HTTP method to be used when sending a
     *                              webhook request.
     * @param string $webhookFilters The list of webhook event triggers that are
     *                               enabled for this Service.
     * @param string $preWebhookUrl The absolute url the pre-event webhook request
     *                              should be sent to.
     * @param string $postWebhookUrl The absolute url the post-event webhook
     *                               request should be sent to.
     * @param integer $preWebhookRetryCount The number of retries in case of
     *                                      pre-event webhook request failures.
     * @param integer $postWebhookRetryCount The number of retries in case of
     *                                       post-event webhook request failures.
     * @return UpdateWebhookOptions Options builder
     */
    public static function update($webhookMethod = Values::NONE, $webhookFilters = Values::NONE, $preWebhookUrl = Values::NONE, $postWebhookUrl = Values::NONE, $preWebhookRetryCount = Values::NONE, $postWebhookRetryCount = Values::NONE) {
        return new UpdateWebhookOptions($webhookMethod, $webhookFilters, $preWebhookUrl, $postWebhookUrl, $preWebhookRetryCount, $postWebhookRetryCount);
    }
}

class UpdateWebhookOptions extends Options {
    /**
     * @param string $webhookMethod The HTTP method to be used when sending a
     *                              webhook request.
     * @param string $webhookFilters The list of webhook event triggers that are
     *                               enabled for this Service.
     * @param string $preWebhookUrl The absolute url the pre-event webhook request
     *                              should be sent to.
     * @param string $postWebhookUrl The absolute url the post-event webhook
     *                               request should be sent to.
     * @param integer $preWebhookRetryCount The number of retries in case of
     *                                      pre-event webhook request failures.
     * @param integer $postWebhookRetryCount The number of retries in case of
     *                                       post-event webhook request failures.
     */
    public function __construct($webhookMethod = Values::NONE, $webhookFilters = Values::NONE, $preWebhookUrl = Values::NONE, $postWebhookUrl = Values::NONE, $preWebhookRetryCount = Values::NONE, $postWebhookRetryCount = Values::NONE) {
        $this->options['webhookMethod'] = $webhookMethod;
        $this->options['webhookFilters'] = $webhookFilters;
        $this->options['preWebhookUrl'] = $preWebhookUrl;
        $this->options['postWebhookUrl'] = $postWebhookUrl;
        $this->options['preWebhookRetryCount'] = $preWebhookRetryCount;
        $this->options['postWebhookRetryCount'] = $postWebhookRetryCount;
    }

    /**
     * The HTTP method to be used when sending a webhook request.
     * 
     * @param string $webhookMethod The HTTP method to be used when sending a
     *                              webhook request.
     * @return $this Fluent Builder
     */
    public function setWebhookMethod($webhookMethod) {
        $this->options['webhookMethod'] = $webhookMethod;
        return $this;
    }

    /**
     * The list of webhook event triggers that are enabled for this Service.
     * 
     * @param string $webhookFilters The list of webhook event triggers that are
     *                               enabled for this Service.
     * @return $this Fluent Builder
     */
    public function setWebhookFilters($webhookFilters) {
        $this->options['webhookFilters'] = $webhookFilters;
        return $this;
    }

    /**
     * The absolute url the pre-event webhook request should be sent to.
     * 
     * @param string $preWebhookUrl The absolute url the pre-event webhook request
     *                              should be sent to.
     * @return $this Fluent Builder
     */
    public function setPreWebhookUrl($preWebhookUrl) {
        $this->options['preWebhookUrl'] = $preWebhookUrl;
        return $this;
    }

    /**
     * The absolute url the post-event webhook request should be sent to.
     * 
     * @param string $postWebhookUrl The absolute url the post-event webhook
     *                               request should be sent to.
     * @return $this Fluent Builder
     */
    public function setPostWebhookUrl($postWebhookUrl) {
        $this->options['postWebhookUrl'] = $postWebhookUrl;
        return $this;
    }

    /**
     * The number of retries in case of pre-event webhook request failures. Maximum 3 retries are allowed, the default value is 0.
     * 
     * @param integer $preWebhookRetryCount The number of retries in case of
     *                                      pre-event webhook request failures.
     * @return $this Fluent Builder
     */
    public function setPreWebhookRetryCount($preWebhookRetryCount) {
        $this->options['preWebhookRetryCount'] = $preWebhookRetryCount;
        return $this;
    }

    /**
     * The number of retries in case of post-event webhook request failures. Maximum 3 retries are allowed, the default value is 0.
     * 
     * @param integer $postWebhookRetryCount The number of retries in case of
     *                                       post-event webhook request failures.
     * @return $this Fluent Builder
     */
    public function setPostWebhookRetryCount($postWebhookRetryCount) {
        $this->options['postWebhookRetryCount'] = $postWebhookRetryCount;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Messaging.V1.UpdateWebhookOptions ' . implode(' ', $options) . ']';
    }
}