<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Taskrouter\V1\Workspace;

use Twilio\Options;
use Twilio\Values;

abstract class WorkflowOptions
{
    /**
     * @param string $friendlyName The friendly_name
     * @param string $assignmentCallbackUrl The assignment_callback_url
     * @param string $fallbackAssignmentCallbackUrl The
     *                                              fallback_assignment_callback_url
     * @param string $configuration The configuration
     * @param integer $taskReservationTimeout The task_reservation_timeout
     * @return UpdateWorkflowOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $assignmentCallbackUrl = Values::NONE, $fallbackAssignmentCallbackUrl = Values::NONE, $configuration = Values::NONE, $taskReservationTimeout = Values::NONE)
    {
        return new UpdateWorkflowOptions($friendlyName, $assignmentCallbackUrl, $fallbackAssignmentCallbackUrl, $configuration, $taskReservationTimeout);
    }

    /**
     * @param string $friendlyName The friendly_name
     * @return ReadWorkflowOptions Options builder
     */
    public static function read($friendlyName = Values::NONE)
    {
        return new ReadWorkflowOptions($friendlyName);
    }

    /**
     * @param string $assignmentCallbackUrl The assignment_callback_url
     * @param string $fallbackAssignmentCallbackUrl The
     *                                              fallback_assignment_callback_url
     * @param integer $taskReservationTimeout The task_reservation_timeout
     * @return CreateWorkflowOptions Options builder
     */
    public static function create($assignmentCallbackUrl = Values::NONE, $fallbackAssignmentCallbackUrl = Values::NONE, $taskReservationTimeout = Values::NONE)
    {
        return new CreateWorkflowOptions($assignmentCallbackUrl, $fallbackAssignmentCallbackUrl, $taskReservationTimeout);
    }
}

class UpdateWorkflowOptions extends Options
{
    /**
     * @param string $friendlyName The friendly_name
     * @param string $assignmentCallbackUrl The assignment_callback_url
     * @param string $fallbackAssignmentCallbackUrl The
     *                                              fallback_assignment_callback_url
     * @param string $configuration The configuration
     * @param integer $taskReservationTimeout The task_reservation_timeout
     */
    public function __construct($friendlyName = Values::NONE, $assignmentCallbackUrl = Values::NONE, $fallbackAssignmentCallbackUrl = Values::NONE, $configuration = Values::NONE, $taskReservationTimeout = Values::NONE)
    {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['assignmentCallbackUrl'] = $assignmentCallbackUrl;
        $this->options['fallbackAssignmentCallbackUrl'] = $fallbackAssignmentCallbackUrl;
        $this->options['configuration'] = $configuration;
        $this->options['taskReservationTimeout'] = $taskReservationTimeout;
    }

    /**
     * The friendly_name
     *
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName)
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The assignment_callback_url
     *
     * @param string $assignmentCallbackUrl The assignment_callback_url
     * @return $this Fluent Builder
     */
    public function setAssignmentCallbackUrl($assignmentCallbackUrl)
    {
        $this->options['assignmentCallbackUrl'] = $assignmentCallbackUrl;
        return $this;
    }

    /**
     * The fallback_assignment_callback_url
     *
     * @param string $fallbackAssignmentCallbackUrl The
     *                                              fallback_assignment_callback_url
     * @return $this Fluent Builder
     */
    public function setFallbackAssignmentCallbackUrl($fallbackAssignmentCallbackUrl)
    {
        $this->options['fallbackAssignmentCallbackUrl'] = $fallbackAssignmentCallbackUrl;
        return $this;
    }

    /**
     * The configuration
     *
     * @param string $configuration The configuration
     * @return $this Fluent Builder
     */
    public function setConfiguration($configuration)
    {
        $this->options['configuration'] = $configuration;
        return $this;
    }

    /**
     * The task_reservation_timeout
     *
     * @param integer $taskReservationTimeout The task_reservation_timeout
     * @return $this Fluent Builder
     */
    public function setTaskReservationTimeout($taskReservationTimeout)
    {
        $this->options['taskReservationTimeout'] = $taskReservationTimeout;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Taskrouter.V1.UpdateWorkflowOptions ' . implode(' ', $options) . ']';
    }
}

class ReadWorkflowOptions extends Options
{
    /**
     * @param string $friendlyName The friendly_name
     */
    public function __construct($friendlyName = Values::NONE)
    {
        $this->options['friendlyName'] = $friendlyName;
    }

    /**
     * The friendly_name
     *
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName)
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Taskrouter.V1.ReadWorkflowOptions ' . implode(' ', $options) . ']';
    }
}

class CreateWorkflowOptions extends Options
{
    /**
     * @param string $assignmentCallbackUrl The assignment_callback_url
     * @param string $fallbackAssignmentCallbackUrl The
     *                                              fallback_assignment_callback_url
     * @param integer $taskReservationTimeout The task_reservation_timeout
     */
    public function __construct($assignmentCallbackUrl = Values::NONE, $fallbackAssignmentCallbackUrl = Values::NONE, $taskReservationTimeout = Values::NONE)
    {
        $this->options['assignmentCallbackUrl'] = $assignmentCallbackUrl;
        $this->options['fallbackAssignmentCallbackUrl'] = $fallbackAssignmentCallbackUrl;
        $this->options['taskReservationTimeout'] = $taskReservationTimeout;
    }

    /**
     * The assignment_callback_url
     *
     * @param string $assignmentCallbackUrl The assignment_callback_url
     * @return $this Fluent Builder
     */
    public function setAssignmentCallbackUrl($assignmentCallbackUrl)
    {
        $this->options['assignmentCallbackUrl'] = $assignmentCallbackUrl;
        return $this;
    }

    /**
     * The fallback_assignment_callback_url
     *
     * @param string $fallbackAssignmentCallbackUrl The
     *                                              fallback_assignment_callback_url
     * @return $this Fluent Builder
     */
    public function setFallbackAssignmentCallbackUrl($fallbackAssignmentCallbackUrl)
    {
        $this->options['fallbackAssignmentCallbackUrl'] = $fallbackAssignmentCallbackUrl;
        return $this;
    }

    /**
     * The task_reservation_timeout
     *
     * @param integer $taskReservationTimeout The task_reservation_timeout
     * @return $this Fluent Builder
     */
    public function setTaskReservationTimeout($taskReservationTimeout)
    {
        $this->options['taskReservationTimeout'] = $taskReservationTimeout;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Taskrouter.V1.CreateWorkflowOptions ' . implode(' ', $options) . ']';
    }
}