<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\TwiML\Voice;

use Twilio\TwiML\TwiML;

class Number extends TwiML
{
    /**
     * Number constructor.
     *
     * @param phoneNumber $phoneNumber Phone Number to dial
     * @param array $attributes Optional attributes
     */
    public function __construct($phoneNumber, $attributes = array())
    {
        parent::__construct('Number', $phoneNumber, $attributes);
    }

    /**
     * Add SendDigits attribute.
     *
     * @param string $sendDigits DTMF tones to play when the call is answered
     * @return TwiML $this.
     */
    public function setSendDigits($sendDigits)
    {
        return $this->setAttribute('sendDigits', $sendDigits);
    }

    /**
     * Add Url attribute.
     *
     * @param url $url TwiML URL
     * @return TwiML $this.
     */
    public function setUrl($url)
    {
        return $this->setAttribute('url', $url);
    }

    /**
     * Add Method attribute.
     *
     * @param httpMethod $method TwiML URL method
     * @return TwiML $this.
     */
    public function setMethod($method)
    {
        return $this->setAttribute('method', $method);
    }

    /**
     * Add StatusCallbackEvent attribute.
     *
     * @param enum :Event $statusCallbackEvent Events to call status callback
     * @return TwiML $this.
     */
    public function setStatusCallbackEvent($statusCallbackEvent)
    {
        return $this->setAttribute('statusCallbackEvent', $statusCallbackEvent);
    }

    /**
     * Add StatusCallback attribute.
     *
     * @param url $statusCallback Status callback URL
     * @return TwiML $this.
     */
    public function setStatusCallback($statusCallback)
    {
        return $this->setAttribute('statusCallback', $statusCallback);
    }

    /**
     * Add StatusCallbackMethod attribute.
     *
     * @param httpMethod $statusCallbackMethod Status callback URL method
     * @return TwiML $this.
     */
    public function setStatusCallbackMethod($statusCallbackMethod)
    {
        return $this->setAttribute('statusCallbackMethod', $statusCallbackMethod);
    }
}